/*
 * TEST OF MAPPING
 * A Plan Adr = c000
 * window adr = b000
 * B Plan adr = e000
 * sprite adr = be00
 * HScrol adr = b800
 */

#include "genesis.h"
#include "tile.h"

/************** Function prototypes *************/
void init_gfx();

void scroll_down_to_A(to,by);
void scroll_down_B(to,by);


/*************  External Vars *************/

/* in UTILS.C */
/* functions pre-defined in GENESIS.H */

/* in TILE.S */
extern ulong tile1[];
extern ulong tile2[];
extern ulong tile3[];

/* in MAP_DEF.S */
extern uint map_def[200*28];

/*************  Main program  ***********/
void main()
{
    register uint posAct;
    register uint i, j, joy;

    /* Initialize Genesis GFX registers */
    init_gfx();
    
    /* Load the charset */
    dma_vram_copy(tile1, 0, 32 + 32 * 4*11 );
    dma_vram_copy(tile2, 32 + 32 * 4*11 , 32 * 5 * 2);
    dma_vram_copy(tile3, 32 + 32 * 4*11 + 32 *5 * 2, 32 * 5 * 2);

    set_colors(0, pal_tile);

    /* i draw the first ting */  
    for (j=0; j< 28; j++)
        for (i=0;i < 32; i++)
            show_tiles(map_def[i+(j*200)], map_def[i+(j*200)], 0, i, j, APLAN, 0); 

    init_joypad();

    posAct = 1;

    while(1)
    {

        joy= read_joypad1();

        if (joy)
        {
                switch(joy & 0xff)
                {
                        case JOY_RIGHT:
                                /* based on the size of the map, 200 - (32 1st tiles i've already drawn */
                                if (posAct <= (200*8 - 32*8) ) posAct++;
                                break;
                        /* this doesn't work in the demo since the redrawn is a little more different, try, you'll see */
                        case JOY_LEFT:
                                if (posAct > 0 ) posAct--;
                                break;


                }

                /* this function scroll field A to pos posAct */
                scrollh_A(-posAct);

                /* posAct is in pixels, i want Tile!! */
                i = posAct/8;
                                                                                         /* be careful 0<i<32 , so i made a i mod 32*/
                for (j=0;j < 28; j++)
                        show_tiles(map_def[(j*200) + 32+i], map_def[(j*200) + 32 +i], 0, i - ( (i/32)*32 ), j, APLAN, 0); 

        }


    }

}

/*
 * Initilize the GFX.
 */
void init_gfx()
{
    register uint *pw;

    pw = (uint *) GFXCNTL;

    *pw = 0x8016;   /* reg. 0 - Enable HBL */
    *pw = 0x8174;   /* reg. 1 - Enable display, VBL, DMA + VCell size */
    *pw = 0x8230;   /* reg. 2 - Plane A =$30*$400=$C000 */
    *pw = 0x832C;   /* reg. 3 - Window  =$38*$400=$D000 */
    *pw = 0x8407;   /* reg. 4 - Plane B =$7*$2000=$E000 */
    *pw = 0x855F;   /* reg. 5 - sprite table begins at $BE00=$5F*$200 */
    *pw = 0x8600;   /* reg. 6 - not used */
    *pw = 0x8700;   /* reg. 7 - Background Color number*/
    *pw = 0x8800;   /* reg. 8 - not used */
    *pw = 0x8900;   /* reg. 9 - not used */
    *pw = 0x8a01;   /* reg 10 - HInterrupt timing */
    *pw = 0x8b00;   /* reg 11 - $0000abcd a=extr.int b=vscr cd=hscr    THIS REGISTER YOU MUST MODIFY TO HAVE HSIZE > 32*/
    *pw = 0x8c08;   /* reg 12 - hcell mode + shadow/highight + interlaced mode */
    *pw = 0x8d2E;   /* reg 13 - HScoll Table = $B800 */
    *pw = 0x8e00;   /* reg 14 - not used */
    *pw = 0x8f02;   /* reg 15 - auto increment data */
    *pw = 0x9000;   /* reg 16 - scrl screen size */
    *pw = 0x9100;   /* reg 17 - window hpos */
    *pw = 0x92ff;   /* reg 18 - window vpos */
}
